class US_ScoringMutator extends Mutator;

var bool Init;

function PostBeginPlay()
{

	Super.PostBeginPlay();

	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int MaxScore, leveldif;
local US_GRI GRI;


        if (( InstigatedBy != none) && (Victim != none))
        {
	//Balance the difference in levels:
	if ( InstigatedBy.IsA('PlayerPawn') && Victim.IsA('PlayerPawn') && InstigatedBy != Victim)
		{
		if ( US_PRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).Level > US_PRI(PlayerPawn(Victim).PlayerReplicationInfo).Level )
			{
			leveldif = US_PRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).Level - US_PRI(PlayerPawn(Victim).PlayerReplicationInfo).Level;
			if ( leveldif > 10 )
				{
				if ( leveldif < 40 )
					ActualDamage *= 0.9;
				else if ( leveldif < 80 )
					ActualDamage *= 0.8;
				else if ( leveldif < 120 )
					ActualDamage *= 0.7;
				else if ( leveldif < 160 )
					ActualDamage *= 0.6;
				else if ( leveldif < 200 )
					ActualDamage *= 0.5;
				else if ( leveldif < 240 )
					ActualDamage *= 0.4;
				else if ( leveldif < 280 )
					ActualDamage *= 0.3;
				else if ( leveldif < 320 )
					ActualDamage *= 0.2;
				else
					ActualDamage *= 0.1;
				}
			}
		}

	if ( InstigatedBy.IsA('PlayerPawn') && Victim != none )
		{
		GRI = US_GRI(PlayerPawn(InstigatedBy).GameReplicationInfo);
		ActualDamage = ActualDamage * US_PRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).BaseDamage / 100;
		if ( ActualDamage > Victim.Health )
			{
			ActualDamage = Victim.Health;
			}
		InstigatedBy.PlayerReplicationInfo.Score += ActualDamage * GRI.Damage;
		}
	else if ( InstigatedBy.IsA('Bot') && Victim != none )
		{
		if ( ActualDamage > Victim.Health )
			{
			ActualDamage = Victim.Health;
			}
		InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
		}
	
	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
    }
}

defaultproperties
{
}
